# Please e-mail mathatfa@gmail.com about bugs in this script.
# 

#require("export")
#require("modelr")
require("tidyverse")
require("tidybayes")
#require("broom")
require("openxlsx")
# require("ggstance")
# require("ggridges")
# require("cowplot")
require("rstan")
require("brms")
#require("emmeans")

rstan_options(auto_write = TRUE)
cores <- 4 # min(4,parallel::detectCores()-1) # 4 chains will NOT sample faster >4 cores
options(mc.cores = cores)
theme_set(theme_light())
options(width = 120)
S_width <- 13.33/2.0
S_height <- 7.5/2

# setwd("/home/dqc/R/ReverseDesign/HarmonizedData Nabe RD 2019-01-23/")
# setwd("/home/drs/R/Nabe-Rat-CCI-flexion/EMG-M.Zhang/HarmonizedData Nabe RD 2019-01-23/")
setwd("C:/DaniilSarkisyan/R/Nabe-Rat-CCI-flexion/EMG-M.Zhang/HarmonizedData Nabe RD 2019-01-23/")
load(file="EMG-RD2019-01-23-data.RData")
setwd("../figs-RD9/")

# Which "AI of Thresholds" model is better by LOO? ----
fName <- "AI_Threshold_RD9-2019-02-02.RData"
fit <- list()
fit.kfold <- list()
mybrm <- function(ModName="mymod", ...) {
  tryCatch({
    fit[[ModName]] <<- brm(
      ..., iter=40000, cores=cores, chains=cores, seed = 20190131, # thin = 4,
      save_all_pars = TRUE, sample_prior = TRUE, 
      control=list(max_treedepth=13, adapt_delta=0.999))
    print(summary(fit[[ModName]]))
    save(fit, fit.kfold, file=fName)
  }, error=function(e){})
  print(paste( ifelse(is.null(fit[[ModName]]), "Failed:", "Saved:"), ModName ))
}

tmp <- emgThrLat %>% 
  mutate( MSL = paste(Muscle, StimLocat, sep="."),
          MSL = factor(MSL, sort(unique(MSL))),
          Op3 = paste0(OperationSide,Operation),
          Op3 = replace(Op3, Operation=="Sham", "Sham"),
          Op3 = factor(Op3, c("Sham","LeftTBI","RightTBI"), c("SO","LTBI","RTBI")) ) %>%
  droplevels(.)
xtabs(~Operation+MSL+Drug, data=tmp)
xtabs(~Op3+MSL, data=tmp)
xtabs(~Operation+MSL+OperationSide, data=tmp)


# AI_Threshold ~ Operation*MSL + (1||RatNo),
mybrm(ModName=paste("AI","2","Thr",sep="."),
      AI_Threshold ~ Operation*Muscle + (1||RatNo),
      data=tmp, family = student() )

mybrm(ModName=paste("AI","3","Thr",sep="."),
      AI_Threshold ~ Op3*Muscle + (1||RatNo),
      data=tmp, family = student() )

mybrm(ModName=paste("AI","4","Thr",sep="."),
      AI_Threshold ~ Operation*OperationSide*Muscle + (1||RatNo),
      data=tmp, family = student() )


# compare all models ----
#load(file=fName)

for(m in names(fit)) {
  if(!is.null(fit.kfold[[m]])) next
  fit.kfold[[m]] <- kfold( fit[[m]] )
  fit.kfold[[m]]$model_name <- m
  print(paste("Validated 10-fold:", m))
  save(fit, fit.kfold, file=fName)
}
#compare_ic(x = fit.kfold, ic = "kfold")

fit.loo <- list()
for(m in names(fit)) {
  if(!is.null(fit.loo[[m]])) next
  fit.loo[[m]] <- loo( fit[[m]], cores=cores )
  fit.loo[[m]]$model_name <- m
  print(paste("Validated LOO:", m))
  save(fit, fit.kfold, fit.loo, file=fName)
}

names(fit)
